#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Another Triangular VoronoiMod01.fsh   by  bitless
//https://www.shadertoy.com/view/WsV3Dt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Author: bitless
// Title: another triangular voronoi 
// Thanks to Patricio Gonzalez Vivo & Jen Lowe for "The Book of Shaders" and inspiration
// Thanks to aiekick and iq for some code from https://www.shadertoy.com/view/ltK3WD and https://www.shadertoy.com/view/MdSGRc

uniform vec2 u_resolution;
uniform vec2 u_mouse;
uniform float u_time;

#define PI 3.1415926

vec2 random2( vec2 p ) {
    return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

vec2 rotate2D(vec2 _st, float _angle,vec2 m){
   
    _st -= m;
    _st =  mat2(cos(_angle),-sin(_angle),
                sin(_angle),cos(_angle)) * _st;
    _st += m;
    return _st;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 st = fragCoord.xy/iResolution.xy;
    vec2 m = vec2(0.5,0.5); 
    
    if (iResolution.y > iResolution.x ) {
        st.y *= iResolution.y/iResolution.x;
        m.y *= iResolution.y/iResolution.x;
    }       
    else {
        st.x *= iResolution.x/iResolution.y;
        m.x *= iResolution.x/iResolution.y;
    }
    vec3 color = vec3(.0);


	st = rotate2D(st,PI*0.666666*((floor(mod(iTime,15.0)/5.0)-1.0)),m);  //rotation on 120 degrees
    st = rotate2D(st,PI*0.666666*pow(smoothstep(0.0,1.0,mod(iTime+1.0,5.0))*(1.0-step(1.0,mod(iTime+1.0,5.0))),2.5),m);  //animate rotation cicle
    // Scale
    st -= m;
    st *= sin(iTime*0.2)*1.0+3.0+cos(smoothstep(0.0,1.0,mod(iTime+1.0,5.0))*(1.0-step(1.0,mod(iTime+1.0,5.0)))*PI*2.0)*0.5; 

    // Tile the space
    vec2 i_st = floor(st);
    vec2 f_st = fract(st);
    
    float m_dist = 9.;  // minimun distance

    vec2 p; 
    vec4 f;
    f.x = 9.;
    
    for(int x=-2;x<=2;x++)
    for(int y=-2;y<=2;y++)
    {	
        p = vec2(x,y); //neightbour
        p += 0.5*sin(iTime*0.2+6.2831*random2(i_st+p)); //animate
		p += .5  - f_st;

        f.y = max(abs(p.x)*.866 - p.y*.5, p.y); 
        if (f.y < f.x)
        {
            m_dist = f.x;
            f.x = f.y;
            f.zw = p;
        }
        else if( f.y < m_dist )
		{
			m_dist = f.y;
		}
    }
	
    m_dist -= f.x;
    
    vec3 n = vec3(0);
    
    if ( (f.x - (-f.z*.866 - f.w*.5)) 	<.0001) 	n = vec3(0.940,0.860,0.907); 
	if ( (f.x - (f.z*.866 - f.w*.5))	<.0001) 	n = vec3(0.970,0.949,0.888);
	if ( (f.x - f.w)					<.0001) 	n = vec3(0.871,0.900,0.960);
	
    color =  n*(0.6+length(f.x)); //base color + distance field shadow
    color -= 0.45*pow(clamp(m_dist*4.0,0.0,1.0),0.2); //edges
    color *= 1.0-smoothstep(0.0,10.0,mod(length(f.x)*100.0,15.0))*0.06; //gradient stripes
    color *= 1.0-step(2.0,mod(length(f.x)*100.0,15.0))*0.05; //thin light stripes

    fragColor = vec4(color,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

